package gov.va.med.domain.model.validation;


/**
 * Contains basic informaiton about a validation error
 * @author PII
 * @version $Id: ValidationError.java,v 1.3 2005/07/13 15:42:54 joel.goldberg Exp $
 * @since MHV 2.0 <br>Jul 2, 2005
 */
public class ValidationError implements IValidationError{
    
    public static String INVALID_DATE_ERROR = "invalidDateError";
    public static String INVALID_NUMBER_ERROR = "invalidNumberError";
    public static String MISSING_FIELD_ERROR = "missingFieldError";
    public static String VALUE_OUT_OF_RANGE_ERROR = "valueOutOfRangeError";
    
    String fieldName;
    String errorKey;
    String errorDescrpition;
    Object [] parameters;
    
    public String getErrorDescrpition() {
        if (errorDescrpition == null) {
            return "Validation error [" + getErrorKey() + "] in field [" + 
            		getFieldName() + "]"; 
        }
        return errorDescrpition;
    }
    public void setErrorDescrpition(String errorDescrpition) {
        this.errorDescrpition = errorDescrpition;
    }
    public String getErrorKey() {
        return errorKey;
    }
    public void setErrorKey(String errorKey) {
        this.errorKey = errorKey;
    }
    public String getFieldName() {
        return fieldName;
    }
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }
    public Object[] getParameters() {
        return parameters;
    }
    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }
}
